#version 330
#extension GL_EXT_gpu_shader4 : enable
//Double PhoenixMod01.fsh  by   russ 
//https://www.shadertoy.com/view/4tGSRD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed   //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//A 'Double Phoenix' fractal
//Julia is Zn+1 = Zn^2 + c
//Phoenix is Zn+1 = Zn^2 + c + a * Zn-1
//I added a term of b * Zn-2, just for fun
//a, b, and c real-only for symmetry
//It looks nice
//Using Morgan's heatmap gradient
//https://www.shadertoy.com/view/4dsSzr

vec3 heatmapGradient(float t) {
    t = 2.*abs(.5-fract(t));
	return clamp((pow(t, 1.5) * 0.8 + 0.2) * vec3(smoothstep(0.0, 0.35, t) + t * 0.5, smoothstep(0.5, 1.0, t), max(1.0 - t * 1.7, t * 7.0 - 6.0)), 0.0, 1.0);
}

float phoenix(vec2 p, vec3 c){
	vec2 p1 = vec2(0), p2=p1;
    for(int i=0;i<100;i++){
     	vec2 tmp = p, sq = p*p;
        if(sq.x + sq.y > 65536.)
            return float(i) - log2(log2(sq.x+sq.y)*.0625);
        p = vec2(sq.x-sq.y+c.x,2.*p.x*p.y) + c.y*p1 + c.z*p2;
        p2 = p1;
        p1 = tmp;
    }
    return -1.;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = 3.*(gl_FragCoord.xy -.5 * iResolution.xy) / iResolution.y;
    float t = phoenix(uv.yx, sin(iTime*vec3(.13,.17,.19)));
    vec3 col = t > 0. ? heatmapGradient(log(t) + .1*iTime) : vec3(.05);
	gl_FragColor = vec4(col ,1.0);
}
